﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VHAReportViewer;

public partial class ReportRandRCareReport : System.Web.UI.Page
{

    #region Variable Declarations

    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    private UserAccountManager _currentUser; 
    string _reportName = "RandRcareReport";

    #endregion

    #region Protected Methods

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            if (!IsPostBack)
            {
                SetDropDownListLevel();
                EnableDropDownListsVisnAndStation(false, false);
            }
            EnableButtonRunReport();
            DisableReportViewer();
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    void Page_PreRender(object sender, EventArgs e)
    {
        EnableButtonRunReport();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            ////ReportParameter reportParam = new ReportParameter("UserId", userId);
            ////_reportParameters.Add(reportParam);

            if (DateFrom.DateValue.Length == 0 || DateFrom.DateValue == null)
            {
                lblDateValidation.Visible = true;
                DateFrom.Focus();
            }
            else
            {
                lblDateValidation.Visible = false;
                if (DropDownListReportLevel.SelectedValue == "National")
                {
                    ReportViewer1.Reset();
                    ReportParameter reportParamFromDate = new ReportParameter("NOTEDATE", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                    _reportParameters.Add(reportParamFromDate);
                    ReportParameter reportParamSurveyTypeString = new ReportParameter("NOTETYPE", CheckBoxNoteStatus.SelectedValue);
                    _reportParameters.Add(reportParamSurveyTypeString);
                    _reportName = "RandRcareReport";
                    ReportViewer1.ServerReport.ReportPath = _reportName;
                    ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

                    if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                    {
                        ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                    }
                    ReportViewer1.ShowParameterPrompts = false;
                    ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
                    ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                    ReportViewer1.ServerReport.Refresh();
                    ReportViewer1.Visible = true;
                }
                else if (DropDownListReportLevel.SelectedValue == "VISN")
                {
                    if (DropDownListVisnID.SelectedIndex > 0)
                    {

                        ReportViewer1.Reset();
                        ReportParameter reportParamFromDate = new ReportParameter("NOTEDATE", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                        _reportParameters.Add(reportParamFromDate);
                        ReportParameter reportParamSurveyTypeString = new ReportParameter("NOTETYPE", CheckBoxNoteStatus.SelectedValue);
                        _reportParameters.Add(reportParamSurveyTypeString);
                        ReportParameter reportParamVisnId = new ReportParameter("FacilityID", (DropDownListVisnID.SelectedValue));
                        _reportParameters.Add(reportParamVisnId);
                        _reportName = "RandRcareReport";
                        ReportViewer1.ServerReport.ReportPath = _reportName;

                        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                        {
                            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                        }
                        ReportViewer1.ShowParameterPrompts = false;
                        ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
                        ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                        ReportViewer1.ServerReport.Refresh();
                        ReportViewer1.Visible = true;
                    }
                }
                else
                {
                    if (DropDownListFacility.SelectedIndex > 0)
                    {
                        ReportViewer1.Reset();

                        ReportParameter reportParamFromDate = new ReportParameter("NOTEDATE", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                        _reportParameters.Add(reportParamFromDate);

                        ReportParameter reportParamSurveyTypeString = new ReportParameter("NOTETYPE", CheckBoxNoteStatus.SelectedValue);
                        _reportParameters.Add(reportParamSurveyTypeString);
                        ReportParameter reportParamVisnId = new ReportParameter("FacilityID", (DropDownListFacility.SelectedValue));
                        _reportParameters.Add(reportParamVisnId);
                        _reportName = "RandRcareReport";
                        ReportViewer1.ServerReport.ReportPath = _reportName;
                        ReportViewer1.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));

                        if (ReportViewer1.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                        {
                            ReportViewer1.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewer1.ServerReport.ReportPath;
                        }
                        ReportViewer1.ServerReport.SetParameters(_reportParameters.ToArray());
                        ReportViewer1.ProcessingMode = ProcessingMode.Remote;
                        ReportViewer1.ShowParameterPrompts = false;
                        ReportViewer1.ShowReportBody = true;
                        ReportViewer1.ServerReport.Refresh();
                        ReportViewer1.Visible = true;
                    }
                }
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Get() ReportData");
        }
    }

    protected void DropDownListReportLevel_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "Select One")
            {
                ButtonRunReport.Enabled = false;
                EnableDropDownListsVisnAndStation(false, false);
            }
            else if (DropDownListReportLevel.SelectedValue == "National")
            {
                ButtonRunReport.Enabled = true;
                EnableDropDownListsVisnAndStation(false, false);
            }
            else
            {
                EnableDropDownListsVisnAndStation(true, false);
                SetDropDownListVisnId();
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Report Level Selecting");
        }
    }

    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "VISN")
            {
                EnableDropDownListsVisnAndStation(true, false);
            }
            else if (DropDownListReportLevel.SelectedValue == "Station")
            {
                SetDropDownListFacility();
                EnableDropDownListsVisnAndStation(true, true);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Visn Selected");
        }
    }

    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Stations Selecting");
        }
    }

    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "Dropdown Visn Selecting");
        }
    }

    #endregion

    #region Private Methods

    private void SetDropDownListVisnId()
    {
        try
        {
            if (!_currentUser.IsInRole(16))
            {
                if (DropDownListReportLevel.SelectedValue == "VISN")
                {
                    DropDownListVisnID.DataSource = ObjectDataSourceDirectlyPermittedVISNs;
                }
                else if (DropDownListReportLevel.SelectedValue == "Station")
                {
                    DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
                }
                DropDownListVisnID.DataBind();
                DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
            }
            DropDownListVisnID.SelectedIndex = 0;
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "SetDropDownListVisnId()");
        }
    }

    private void SetDropDownListFacility()
    {
        try
        {
            if (DropDownListVisnID.SelectedIndex != 0)
            {
                if (_currentUser.IsInRole(16))
                {
                    DropDownListFacility.DataSource = ObjectDataSource3;
                }
                else
                {
                    DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
                }
                DropDownListFacility.DataBind();
                DropDownListFacility.Items.Insert(0, new ListItem("Select Facilities", "000"));
                DropDownListFacility.SelectedIndex = 0;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "SetDropDownListFacility()");
        }
    }

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18) || _currentUser.IsInRole(413) || _currentUser.IsInRole(417));
    }

    private void SetDropDownListLevel()
    {
        try
        {
            _currentUser = (UserAccountManager)HttpContext.Current.User;
            AddListItem("Select One");
            //TODO ROLE
            if (_currentUser.IsInRole(16))
            {
                AddListItem("National");
                //AddListItem("VISN");
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }

            if (_currentUser.IsInRole(17))
            {
                //AddListItem("VISN");
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }

            if (_currentUser.IsInRole(18))
            {
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion SetDropDownListLevel()");
        }
    }

    private void AddListItem(string itemValue)
    {
        try
        {
            var listItem = new ListItem(itemValue);
            if (!DropDownListReportLevel.Items.Contains(listItem))
            {
                DropDownListReportLevel.Items.Add(listItem);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Function AddListItem()");
        }
    }

    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
        DropDownListVisnID.Visible = dropDownListVisnIdIsVisible;
        DivVISN.Visible = dropDownListVisnIdIsVisible;
        DropDownListFacility.Visible = dropDownListFacilityIsVisible;
        DivStation.Visible = dropDownListFacilityIsVisible;
    }

    private void EnableButtonRunReport()
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "Select One" ||
                 (DropDownListReportLevel.SelectedValue == "VISN" && DropDownListVisnID.SelectedIndex < 1) ||
                 (DropDownListReportLevel.SelectedValue == "Station" &&
                  (DropDownListVisnID.SelectedIndex < 1
                   || DropDownListFacility.SelectedIndex < 1))
                )
            {
                ButtonRunReport.Enabled = false;
            }
            else
            {
                ButtonRunReport.Enabled = true;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100023", "private Fucntion EnableButtonRunReport()");
        }
    }

    private void DisableReportViewer()
    {
        ReportViewerNational.Visible = false;
        ReportViewerVisn.Visible = false;
        ReportViewerStation.Visible = false;
    }

    #endregion

}

